<?php
session_start();
/***********************************************
صفحة حفظ ترتيب الصفوف وتصدير الجدول إلى CSV
************************************************/

// استدعاء الإعدادات والملفات الضرورية
$conc_type='cp_exec_conc';
include '../conf.php';
include '../conf_sub.php';
//include $cp_exec_conc;
include("../injection.php");

// التحقق من تسجيل الدخول
if (!isset($_SESSION[$domain . '_user']) || $_SESSION[$domain . '_user'] == "") {
    die;
}

// ✅ السماح فقط بالتاجات الآمنة (بدون خصائص)
$allowed_tags = '<table><tr><td><th>';
$clean_html = strip_tags($_POST['table_html'], $allowed_tags);

// ✅ استخدام DOMDocument لتنظيف الخصائص الخطيرة
libxml_use_internal_errors(true);
$dom = new DOMDocument();
@$dom->loadHTML('<?xml encoding="utf-8" ?>' . $clean_html);

$tags = $dom->getElementsByTagName('*');
foreach ($tags as $tag) {
    while ($tag->attributes->length) {
        $tag->removeAttributeNode($tag->attributes->item(0)); // حذف جميع الخصائص
    }
}

// استخراج الصفوف
$rows = $dom->getElementsByTagName('tr');

// إعداد الهيدر لتصدير CSV
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="table.csv"');

$output = fopen('php://output', 'w');
fwrite($output, "\xEF\xBB\xBF"); // BOM لدعم UTF-8 والعربية

// كتابة كل صف في CSV
foreach ($rows as $row) {
    $data = [];
    foreach ($row->childNodes as $cell) {
        if ($cell->nodeType === XML_ELEMENT_NODE && in_array($cell->nodeName, ['td', 'th'])) {
            $text = trim($cell->textContent);
            $colspan = $cell->hasAttribute('colspan') ? (int)$cell->getAttribute('colspan') : 1;

            $data[] = $text;
            for ($i = 1; $i < $colspan; $i++) {
                $data[] = '';
            }
        }
    }
    fputcsv($output, $data);
}

fclose($output);
exit;
?>
