<?php
session_start();

// إعدادات
$length = 5; 
$width = 160;
$height = 60;
$fontFile = __DIR__ . '/fonts/Roboto-Bold.ttf';
$fontSize = 40;

// إنشاء الكود العشوائي (أرقام فقط)
$chars = '23456789';
$captcha = '';
for ($i = 0; $i < $length; $i++) {
    $captcha .= $chars[random_int(0, strlen($chars)-1)];
}

// تخزينه في السيشن
$_SESSION['captcha_code'] = $captcha;
$_SESSION['captcha_time'] = time();

// إنشاء الصورة
$image = imagecreatetruecolor($width, $height);

// ألوان
$bg = imagecolorallocate($image, 245, 245, 245);
$noiseColor = imagecolorallocate($image, 160, 160, 160);
$lineColor = imagecolorallocate($image, 120, 120, 120);
$txtColor = imagecolorallocate($image, 20, 20, 20);

// تعبئة الخلفية
imagefilledrectangle($image, 0, 0, $width, $height, $bg);

// خطوط تشويش بسيطة
for ($i = 0; $i < 5; $i++) {
    imageline($image, random_int(0,$width), random_int(0,$height), random_int(0,$width), random_int(0,$height), $lineColor);
}

// نقاط ضوضاء
for ($i = 0; $i < 300; $i++) {
    imagesetpixel($image, random_int(0,$width), random_int(0,$height), $noiseColor);
}

// كتابة الأرقام بشكل مستقيم وواضح
$spacing = $width / ($length + 1);
for ($i = 0; $i < $length; $i++) {
    $digit = $captcha[$i];
    $x = ($i + 0.5) * $spacing;
    $y = ($height / 2) + ($fontSize / 2) - 5;

    if (file_exists($fontFile)) {
        imagettftext($image, $fontSize, 0, (int)$x, (int)$y, $txtColor, $fontFile, $digit);
    } else {
        imagestring($image, 5, (int)$x, (int)($y - 20), $digit, $txtColor);
    }
}

// إخراج الصورة
header('Content-Type: image/png');
imagepng($image);
imagedestroy($image);
exit;
?>
