<?php
session_start();
$error_arr=[];
if(!isset($_GET["id"]) || filter_var($_GET["id"], FILTER_VALIDATE_INT )=== false || $_GET["id"]==''){array_push($error_arr,'خطأ فى ال id');$status='not_done';$message='خطأ فى المدخلات';die('هناك خطأ فى رقم الاختبار');}


// الاتصال بقاعدة البيانات
include "db.php";
mysqli_set_charset($conn, "utf8");

// جلب كل الأسئلة
$questions = [];
$qRes = mysqli_query($conn, "SELECT id, ques_sort,ques_text,ques_type,images,videos,ques_required,ques_level,ques_shuffle,ques_dgree,ques_min,ques_max,ques_length,ques_width,ques_show_answer FROM form_questions where test_id= $_GET[id] and deleted=0 ORDER BY ques_level,ques_sort asc");
while ($row = mysqli_fetch_assoc($qRes)) {
	$row = clean_array($row);
    $questions[$row['id']] = [
        "id" => (int)$row['id'],
        "ques_text" => $row['ques_text'],
		"ques_type" => $row['ques_type'],
		"images" => $row['images'],
		"videos" => $row['videos'],
		"ques_required" => $row['ques_required'],
		"ques_level" => $row['ques_level'],
		"ques_dgree" => $row['ques_dgree'],
		"ques_min" => $row['ques_min'],
		"ques_max" => $row['ques_max'],
		"ques_length" => $row['ques_length'],
		"ques_width" => $row['ques_width'],
		"ques_shuffle" => $row['ques_shuffle'],
		"ques_show_answer" => $row['ques_show_answer'],
		"ques_sort" => $row['ques_sort'],
        "options" => []
    ];
}


if (empty($questions)) {
    // عرض رسالة منسقة بسيطة
    ?>
    <!DOCTYPE html>
    <html lang="ar">
    <head>
        <meta charset="UTF-8">
        <title>لا يوجد أسئلة</title>
        <link rel="stylesheet" href="css/style_cp.css">
        <style>
            body{font-family: Tahoma, Arial; padding:30px; direction:rtl;}
            .notice{background:#fff3cd;border:1px solid #ffeeba;padding:20px;border-radius:6px;color:#856404;}
            a.btn{display:inline-block;margin-top:12px;padding:8px 12px;background:#007bff;color:#fff;border-radius:4px;text-decoration:none;}
        </style>
    </head>
    <body>
        <div class="notice">
            <h3>لا توجد أسئلة لهذا الاختبار</h3>
            <p>رقم الاختبار: <strong><?php echo htmlspecialchars($_GET["id"]); ?></strong></p>
            <p>ربما الرقم خاطئ أو لم يتم إضافة أسئلة بعد.</p>
            <a class="btn" href="tests_list.php">العودة لقائمة الاختبارات</a>
        </div>
    </body>
    </html>
    <?php
    exit;
}


// جلب كل الاختيارات وربطها بالأسئلة
$oRes = mysqli_query($conn, "SELECT id, ques_id, option_text,option_dgree,option_sort,option_answer,images,conditions, next_ques_id FROM form_options where deleted=0 ORDER BY ques_id,option_sort asc");
while ($row = mysqli_fetch_assoc($oRes)) {
	$row = clean_array($row);
    $questions[$row['ques_id']]["options"][] = [
        "id" => (int)$row['id'],
        "option_text" => $row['option_text'],
		"option_dgree" => $row['option_dgree'],
		"option_sort" => $row['option_sort'],
		"option_answer" => $row['option_answer'],
		"images" => $row['images'],				
		"conditions" => $row['conditions'],
        "next_ques_id" => $row['next_ques_id'] ? (int)$row['next_ques_id'] : null
    ];
}

//تنظيف الاراى
$questions = array_filter($questions, function($q) {
    return isset($q['id']) && isset($q['ques_text']);
});

echo '<pre>';
print_r($questions);
echo '</pre>';
?>
<!DOCTYPE html>
<html lang="ar">
<head>
<meta charset="UTF-8">
<title>شجرة القرارات</title>

<link rel="stylesheet" href="../css/form_generate_cp.css">

</head>
<body>

<div class='form_create_cont' >
	<h2 style='margin-top:40px;font-size:22px;'>
	📌 انشاء نموذج جديد 
	<div title="اختيار جديد" class="add_ques" test_id="1">➕ سؤال جديد </div>
	<div title="حفظ" class="save_ques_sort" test_id="1">💾 حفظ </div>
	</h2>

	<div id='message_back'></div>
	<div id='message_condition_back'></div>


	<div id='add_ques_message' class='message'>
		<div class='message_title'>اضافة سؤال جديد</div>
		<div class='message_body'>
			<span>
				السؤال
				<span class='editor_btn_cont'>
					<span class="editor_btn bold">B</span>
					<span class="editor_btn italic">I</span>
					<span class="editor_btn underline">U</span>
					<span class="editor_btn colorRed">🔴</span>
					<span class="editor_btn colorBlue">🔵</span>
					<span class="editor_btn addLink">🔗</span>
					<span class="editor_btn removeLink">❌ إزالة رابط</span>
					<span class="editor_btn clearFormat">🧹 مسح التنسيقات</span>
				</span>
				

			
		
			<div id="add_ques_message_editor" class='text_editor' style='height:auto' contenteditable="true" style='margin-top:10px;'></div>
			
			<input type='hidden' id='add_ques_message_input' />
			</span>
			<span>
			نوع السؤال
			<select id="add_ques_message_type">
					<option value="اختيار واحد من متعدد">اختيار واحد من متعدد</option>
					<option value="اكثر من اختيار من متعدد">اكثر من اختيار من متعدد</option>
					<option value="قائمة">قائمة</option>
					<option value="نص قصير">نص قصير</option>
					<option value="نص طويل">نص طويل</option>
					<option value="رقم">رقم</option>
					<option value="رقم عشرى">رقم عشرى</option>
					<option value="شريط منزلق">شريط منزلق</option>
					<option value="لون">لون</option>
					<option value="رابط">رابط</option>
					<option value="بريد الكترونى">بريد الكترونى</option>
					<option value="تليفون">تليفون</option>
					<option value="موبايل">موبايل</option>
					<option value="تاريخ">تاريخ</option>
					<option value="تاريخ (من-الى)">تاريخ (من-الى)</option>
					<option value="وقت">وقت</option>
					<option value="وقت (من-الى)">وقت (من-الى)</option>
					<option value="تاريخ ووقت">تاريخ ووقت</option>
					<option value="تاريخ ووقت (من-الى)">تاريخ ووقت (من-الى)</option>
					<option value="صور">صور</option>
					<option value="ملفات">ملفات</option>
				</select>
			</span>
			
			

			<span style='width:31%;float:right'> 
					<label >الزامية الحقل</label> 
					<select id='add_ques_required'>
						<option value="0">لا</option>
						<option value="1">نعم</option>	
					</select>
			</span>
			
			
			<span style='width:31%;float:right'>
					<label >اظهار الاجابة</label> 
					<select id='add_ques_show_answer'>
						<option value="0">لا</option>
						<option value="1">نعم</option>	
					</select>
			</span>
			
			<span style='width:31%;float:right'>
					<label >عرض الحقل</label> 
					<select id='add_ques_width'>
						<option value="1">100%</option>
						<option value="2">50%</option>
						<option value="3">33%</option>
					</select>
			</span>
			
			
			<span style='width:31%;float:right'>
				<label >درجة السؤال</label> 	
				<input value='0' type="number" step="0.01" id="add_ques_dgree" />
			</span>
			
			
			<span style='width:31%;float:right'>
					<label >عشوائية ترتيب الاجابات</label> 
					<select id='add_ques_shuffle'>
						<option value="0">لا</option>
						<option value="1">نعم</option>	
					</select>
			</span>
			
			<span style='width:31%;float:right'>
					<label >مستوى السؤال</label> 
					<select id='add_ques_level'>
						<option value="1">1</option>
						<option value="2">2</option>
						<option value="3">3</option>
						<option value="4">4</option>
						<option value="5">5</option>
						<option value="6">6</option>
						<option value="7">7</option>
						<option value="8">8</option>
						<option value="9">9</option>
					</select>
			</span>
			


			
			<span style='width:31%;float:right'>
				<label >عدد الحروف</label> 	
				<input value='0' type="number"  id="add_ques_length" />
			</span>	
			
			<span style='width:31%;float:right'>
				<label >اقل قيمة</label> 	
				<input value='0' type="number"  id="add_ques_min" />
			</span>		
			
			<span style='width:31%;float:right'>
				<label >اكبر قيمة</label> 	
				<input value='0' type="number"  id="add_ques_max" />
			</span>			
			
			
			

			
			<span>
			<label class="upload-icon" for="add_ques_message_images"><div class="attach">📎 اضافة صورة او ملف</div> </label> 
			<input required class="file_upload" type="hidden" />
			<input required class="input" type="file" id="add_ques_message_images" accept="image/*"  multiple hidden /><input type='hidden' id='add_ques_message_images_text' class="images" /> 
			<div class="file_preview-container" id='add_ques_preview_sortable'></div>
			</span>
			
			
			<span>
				<label >رابط الفيديو</label> 	
				<input  type="url" id="add_ques_video" />
			</span>
			
			
			
		</div>
		<button id='add_ques_message_button' test_id='<?php echo $_GET['id']; ?>'>اضافة</button>
	</div>



	<div id='edit_ques_message' class='message'>
		<div class='message_title'>تعديل السؤال</div>
		<div class='message_body'>
			<span>
			السؤال
			<span class='editor_btn_cont'>
					<span class="editor_btn bold">B</span>
					<span class="editor_btn italic">I</span>
					<span class="editor_btn underline">U</span>
					<span class="editor_btn colorRed">🔴</span>
					<span class="editor_btn colorBlue">🔵</span>
					<span class="editor_btn addLink">🔗</span>
					<span class="editor_btn removeLink">❌ إزالة رابط</span>
					<span class="editor_btn clearFormat">🧹 مسح التنسيقات</span>
			</span>
			
			
			
			<div id="edit_ques_message_editor" class='text_editor' style='height:auto' contenteditable="true" style='margin-top:10px;'> </div>
			<input type='hidden' id='edit_ques_message_input' />
			</span>
			<span>
			نوع السؤال
			<select id="edit_ques_message_type">
					<option value="اختيار واحد من متعدد">اختيار واحد من متعدد</option>
					<option value="اكثر من اختيار من متعدد">اكثر من اختيار من متعدد</option>
					<option value="قائمة">قائمة</option>
					<option value="نص قصير">نص قصير</option>
					<option value="نص طويل">نص طويل</option>
					<option value="رقم">رقم</option>
					<option value="رقم عشرى">رقم عشرى</option>
					<option value="شريط منزلق">شريط منزلق</option>
					<option value="لون">لون</option>
					<option value="رابط">رابط</option>
					<option value="بريد الكترونى">بريد الكترونى</option>
					<option value="تليفون">تليفون</option>
					<option value="موبايل">موبايل</option>
					<option value="تاريخ">تاريخ</option>
					<option value="تاريخ (من-الى)">تاريخ (من-الى)</option>
					<option value="وقت">وقت</option>
					<option value="وقت (من-الى)">وقت (من-الى)</option>
					<option value="تاريخ ووقت">تاريخ ووقت</option>
					<option value="تاريخ ووقت (من-الى)">تاريخ ووقت (من-الى)</option>
					<option value="صور">صور</option>
					<option value="ملفات">ملفات</option>
				</select>
			</span>
			
			<span style='width:31%;float:right'> 
					<label >الزامية الحقل</label> 
					<select id='edit_ques_required'>
						<option value="0">لا</option>
						<option value="1">نعم</option>	
					</select>
			</span>
			
			<span style='width:31%;float:right'>
				<label >درجة السؤال</label> 	
				<input type="number" step="0.01" id="edit_ques_dgree" />
			</span>
			
			
			<span style='width:31%;float:right'>
					<label >اظهار الاجابة</label> 
					<select id='edit_ques_show_answer'>
						<option value="0">لا</option>
						<option value="1">نعم</option>	
					</select>
			</span>
			
			<span style='width:31%;float:right'>
					<label >عرض الحقل</label> 
					<select id='edit_ques_width'>
						<option value="1">100%</option>
						<option value="2">50%</option>
						<option value="3">33%</option>
					</select>
			</span>
			
			
			
			<span style='width:31%;float:right'>
					<label >عشوائية ترتيب الاجابات</label> 
					<select id='edit_ques_shuffle'>
						<option value="0">لا</option>
						<option value="1">نعم</option>	
					</select>
			</span>
			
			

			<span style='width:31%;float:right'>
					<label >مستوى السؤال</label> 
					<select id='edit_ques_level'>
						<option value="1">1</option>
						<option value="2">2</option>
						<option value="3">3</option>
						<option value="4">4</option>
						<option value="5">5</option>
						<option value="6">6</option>
						<option value="7">7</option>
						<option value="8">8</option>
						<option value="9">9</option>
					</select>
			</span>
			
			
			
			<span style='width:31%;float:right'>
				<label >عدد الحروف</label> 	
				<input value='0' type="number"  id="edit_ques_length" />
			</span>	
			
			<span style='width:31%;float:right'>
				<label >اقل قيمة</label> 	
				<input value='0' type="number"  id="edit_ques_min" />
			</span>		
			
			<span style='width:31%;float:right'>
				<label >اكبر قيمة</label> 	
				<input value='0' type="number"  id="edit_ques_max" />
			</span>	
			
			
			
			<span>
			<label class="upload-icon" for="edit_ques_message_images"><div class="attach">📎 اضافة صورة او ملف</div> </label> 
			<input required class="file_upload" type="hidden" />
			<input required class="input" type="file" id="edit_ques_message_images" accept="image/*"  multiple hidden /><input type='hidden' id='edit_ques_message_images_text' class="images" /> 
			<div class="file_preview-container" id='edit_ques_preview_sortable' ></div>
			</span>
			
			
			<span>
				<label >رابط الفيديو</label> 	
				<input  type="url" id="edit_ques_video" />
			</span>
			
			
			
		</div>
		<button id='edit_ques_message_button'>تعديل</button>
		
	</div>

	<div id='add_option_message' class='message'><div class='message_title'>اضافة اختيار جديد</div>

		<div class='message_body'>
			<span>عنوان الاختيار</span>
			<input id='add_option_message_input'/> 
			
			<span style='width:48%;float:right'>
				<label >درجة الاختيار</label> 	
				<input value='0' type="number" step="0.01" id="add_option_message_dgree" />
			</span>
			

			<span style='width:48%;float:right'>
					<label >الاجابة الصحيحة</label> 
					<select id='add_option_message_answer'>
						<option value="0">لا</option>
						<option value="1">نعم</option>	
					</select>
			</span>
			
			
			 
			<span>
			<label class="upload-icon" for="add_option_message_images"><div class="attach">📎 اضافة صورة او ملف</div> </label> 
			<input required class="file_upload" type="hidden" />
			<input required class="input" type="file" id="add_option_message_images" accept="image/*"  multiple hidden /><input type='hidden' id='add_option_message_images_text' class="images" /> 
			<div class="file_preview-container" id='add_option_preview_sortable'></div>
			</span>
			

			
			<span>الشروط <div class='add_condition' type='add'>➕  </div> </span>
			<div id='conditions_cont' class='div_disabled'>
				
				
				
			</div>
			<textarea id='conditions_text'></textarea>
			
			
		</div>
		<button id='add_option_message_button'>اضافة</button>
	</div>


	<div id='edit_option_message' class='message'>
		<div class='message_title'>تعديل الاختيار</div>
		<div class='message_body'>
			<span>عنوان الاختيار</span>
			<input id='edit_option_message_input'/>

			<span style='width:48%;float:right'>
				<label >درجة الاختيار</label> 	
				<input value='0' type="number" step="0.01" id="edit_option_message_dgree" />
			</span>
			
			<span style='width:48%;float:right'>
					<label >الاجابة الصحيحة</label> 
					<select id='edit_option_message_answer'>
						<option value="0">لا</option>
						<option value="1">نعم</option>	
					</select>
			</span>
			
			 
			<span>
			<label class="upload-icon" for="edit_option_message_images"><div class="attach">📎 اضافة صورة او ملف</div> </label> 
			<input required class="file_upload" type="hidden" />
			<input required class="input" type="file" id="edit_option_message_images" accept="image/*"  multiple hidden /><input type='hidden' id='edit_option_message_images_text' class="images" /> 
			<div class="file_preview-container" id='edit_option_preview_sortable'></div>
			</span>
			
			
			
			<span>الشروط <div class='add_condition' type='edit '>➕ </div> </span>
			<div id='conditions_edit_cont' class='div_disabled'>
				
				
				
			</div>
			<textarea id='conditions_edit_text'></textarea>
			
			
			
		</div> 
		
		<button id='edit_option_message_button'>تعديل</button>
		
	</div>



	<div id='add_condition_message' class='message message_condition'>
	<div class='message_title'>اضافة شرط جديد</div>
	<div class='message_body'>
	<div class='condition_value'>القيمة التى سيدخلها الزائر(???) </div>
	<br>
	<select id='conditions_marks'>
	<option value='='>يساوى</option>
	<option value='like'>يحتوى على</option>
	<option value='>' >اكبر من</option>
	<option value='<'>اصغر من</option>
	<option value='<>'>لاتساوى</option>

	</select>

	<select id='add_condition_message_type'>
	<option value='0'>قيمة ثابتة</option>
	<option value='1'>بحث</option>
	</select>

	<input id="add_condition_message_input_fixed" />
	<select id='add_condition_message_input_list' style='display:none'>
	<option value='اسم المستحق'>اسم المستحق</option>
	<option value='رقم الهوية'>رقم الهوية</option>
	</select>


	<button id='add_condition_message_button'>اضافة</button>
	</div>



	</div>



	<div class="ques_container">



	<?php

		

		foreach ($questions as $q): 
	?>
		<div class="ques_box" current_sort="<?php echo $q['ques_sort']; ?>" current_q="<?php echo  $q['id']; ?>">
			
			<div title='اخفاء السؤال' class='ques_icon hide_ques'  status='0'>▼</div>
			<div title='حذف السؤال' class='ques_icon delete_ques'  current_id="<?php echo  $q['id']; ?>">🗑️</div>
			<span current_id='<?php echo $q['id'];?>' current_text='<?php echo $q['ques_text'];?>' current_type='<?php echo $q['ques_type'];?>' current_images='<?php echo $q['images'];?>' current_videos='<?php echo $q['videos'];?>'  current_required='<?php echo $q['ques_required'];?>'  current_show_answer='<?php echo $q['ques_show_answer'];?>' current_level='<?php echo $q['ques_level'];?>'  current_dgree='<?php echo $q['ques_dgree'];?>' current_min='<?php echo $q['ques_min'];?>' current_max='<?php echo $q['ques_max'];?>' current_width='<?php echo $q['ques_width'];?>' current_length='<?php echo $q['ques_length'];?>'   current_shuffle='<?php echo $q['ques_shuffle'];?>'  class='edit_ques'>✏️</span>
			<div class='save_options_sort'>💾</div>
			
			<div title='تعديل السؤال' class="ques_text" current_id="<?php echo $q['id'];?>" >
			<span class='ques_text_text'><?php echo $q['ques_text']; ?></span>
			<span class='ques_type'><?php echo $q['ques_type']; ?></span>
			<span class='ques_level'>مستوى :<?php echo $q['ques_level']; ?></span>

			</div>
			
			<div class='options_cont <?php if($q['ques_type']!='اكثر من اختيار من متعدد' && $q['ques_type']!='اختيار واحد من متعدد' && $q['ques_type']!='قائمة' ) {echo 'not_options'; } ?>' >
				<div class="options">
					<?php foreach ($q['options'] as $opt): ?>
						<div class="option_cont" current_id="<?php echo $opt['id'];?>" current_conditions="<?php echo $opt['conditions'];?>" current_text="<?php echo $opt['option_text'];?>" current_answer="<?php echo $opt['option_answer'];?>"  current_images="<?php echo $opt['images'];?>" current_dgree="<?php echo $opt['option_dgree'];?>" next_id="<?php echo $opt['next_ques_id']; ?>" >
						   
						   <div class='option_text option_float text'><input class='option_check' type='checkbox' /><?php echo  htmlspecialchars($opt['option_text']); ?></div>
							<div title='تعديل الاختيار' class='edit_option option_float'>✏️</div>
							<div title='حذف الاختيار' class='delete_option option_float'>🗑️</div>
							
						</div>
					<?php endforeach; ?>
					
					
				</div>
				<div title='اختيار جديد' class='add_option' ques_id="<?php echo $q['id'];?>">➕ اختيار جديد </div>
			</div>
		</div>
	<?php endforeach; ?>

	</div>
	<div>
		<div title="اختيار جديد" class="add_ques" test_id="1">➕ سؤال جديد </div>
		<div title="حفظ" class="save_ques_sort" test_id="1">💾 حفظ </div>
	</div>
</div>

<script src="../js/jquery.ui.js"></script>
<script src="../js/jquery-3.6.0.min.js"></script>
<script src="../js/form_generate.js" ></script>
<script src="../js/files_upload.js"></script>

</body>
</html>
