$(function () {		
					
	// 🗑️ حذف المعاينة
	$(document).on('click', ".delete_preview", function (e) { 
		let textFieldId = $(this).attr('text_field');
		let textField = $("#" + textFieldId);
		let valueToRemove = $(this).attr("value");

		// إزالة اسم الملف من الحقل النصي
		textField.val(textField.val().replace(',' + valueToRemove, "")); 
		
		// حذف العنصر من الصفحة
		$(this).parent().remove();
	});

	// 📤 عند اختيار الملفات
	$(document).on('change', "#image-input", function (e) { 
		let files = e.target.files;
		if (files.length === 0) return;

		current_text_field = $(this).attr('text_field');
		totalFiles = files.length;
		uploadedFiles = 0;

		$("#send_icon").prop("disabled", true).removeClass("enabled");

		$.each(files, function(i, file) {
			let id = "file-" + Math.random().toString(36).substr(2, 9);

			// 📄 عرض المعاينة حسب نوع الملف
			if (file.type === "application/pdf") {
				// PDF ➜ عرض صورة pdf.png
				$("#file_preview-container").show();
				$("#file_preview-container").prepend(`
					<div class="file_preview" id="${id}">
						<img src="img/pdf.webp" alt="${file.name}" class="pdf-icon">
						<div class="progress-circle">0%</div>
					</div>
				`);
			} else if (file.type === "image/png" || file.type === "image/jpeg") {
				// صورة ➜ عرض المعاينة
				let reader = new FileReader();
				reader.onload = function(e) {
					$("#file_preview-container").show();
					$("#file_preview-container").prepend(`
						<div class="file_preview" id="${id}">
							<img src="${e.target.result}" alt="${file.name}">
							<div class="progress-circle">0%</div>
						</div>
					`);
				}
				reader.readAsDataURL(file);
			} else {
				alert("❌ الملف " + file.name + " غير مدعوم (فقط PNG / JPG / PDF)");
				return;
			}

			// بدء رفع الملف
			uploadImage(file, id, current_text_field);
		});

		// تفريغ الاختيار
		$("#image-input").val("");
	});

	// 🚀 دالة رفع الملفات
	function uploadImage(file, file_previewId, text_field) {
		let formData = new FormData();
		formData.append("files[]", file);

		$.ajax({
			xhr: function() {
				let xhr = new window.XMLHttpRequest();
				xhr.upload.addEventListener("progress", function(e) {
					if (e.lengthComputable) {
						let percent = Math.round((e.loaded / e.total) * 100);
						$("#" + file_previewId + " .progress-circle").text(percent + "%");
					}
				});
				return xhr;
			},
			url: "upload_imfiles.php", // 🔹 عدّل هذا إلى مسار رفع الملفات في موقعك
			type: "POST",
			data: formData,
			processData: false,
			contentType: false,
			dataType: "json",
			success: function(resp) {
				if (Array.isArray(resp) && resp[0] && resp[0].success) {
					$("#" + text_field).val($("#" + text_field).val() + ',' + resp[0].file);
					$("#" + file_previewId + " .progress-circle").text("✔️").css("background", "rgba(0,150,0,0.7)");
					$("#" + file_previewId ).append("<div  class='file_name_preview' >" + resp[0].file_title + "<div>");
					// زر الحذف
					$("#" + file_previewId).append(`
						<div value="${resp[0].file}" text_field="${text_field}" class="delete_preview">🗑️</div>
					`);
				} else {
					$("#" + file_previewId + " .progress-circle").text("❌").css("background", "rgba(200,0,0,0.7)");
				}
				uploadedFiles++;
				checkAllUploaded();
			},
			error: function(xhr, status, error) {
				console.log("AJAX Error:", status, error, xhr.responseText);
				$("#" + file_previewId + " .progress-circle").text("❌").css("background", "rgba(200,0,0,0.7)");
				uploadedFiles++;
				checkAllUploaded();
			}
		});
	}

	// ✅ التحقق من انتهاء الرفع
	function checkAllUploaded() {
		if (uploadedFiles === totalFiles) {
			$("#send_icon").prop("disabled", false).addClass("enabled");
		}
	}
});
