<?php
header('Content-Type: application/json; charset=utf-8');

$uploadDir = __DIR__ . "/../uploads/images/";
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0755, true);
}

$response = [];
$allowedExt = ['jpg', 'jpeg', 'png', 'webp'];
$allowedMime = ['image/jpeg', 'image/png', 'image/gif', 'image/webp'];

// أقصى حجم (3MB)
$maxSize = 3 * 1024 * 1024;

// التحقق من استقبال الملفات
if (!isset($_FILES['files'])) {
    echo json_encode(['success' => false, 'msg' => 'لم يتم استقبال أي ملف']);
    exit;
}

foreach ($_FILES['files']['tmp_name'] as $index => $tmpName) {
    $name = $_FILES['files']['name'][$index];
    $size = $_FILES['files']['size'][$index];

    // التحقق من الحجم
    if ($size > $maxSize) {
        $response[] = ['success' => false, 'msg' => "الحجم أكبر من 3MB"];
        continue;
    }

    // استخراج الامتداد + اسم الملف بدون الامتداد
    $ext = strtolower(pathinfo($name, PATHINFO_EXTENSION));
    $filenameOnly = pathinfo($name, PATHINFO_FILENAME);

    // تنظيف اسم الملف حتى لا يحتوي رموز غير مناسبة
    $safeName = preg_replace('/[^\p{Arabic}A-Za-z0-9_\-]/u', '_', str_replace('.', '_', $filenameOnly));

    // التحقق من نوع الصورة الحقيقي + الامتداد
    $mime = mime_content_type($tmpName);
    if (!in_array($ext, $allowedExt) || !in_array($mime, $allowedMime)) {
        $response[] = ['success' => false, 'msg' => "امتداد أو نوع غير مسموح: $ext"];
        continue;
    }

    // قراءة الصورة حسب النوع
    $img = null;
    switch ($ext) {
        case 'jpg':
        case 'jpeg':
            $img = @imagecreatefromjpeg($tmpName);
            break;
        case 'png':
            $img = @imagecreatefrompng($tmpName);
            imagepalettetotruecolor($img);
            imagealphablending($img, true);
            imagesavealpha($img, true);
            break;
        case 'webp':
            $img = @imagecreatefromwebp($tmpName);
            break;
    }

    if (!$img) {
        $response[] = ['success' => false, 'msg' => "فشل قراءة الصورة"];
        continue;
    }

    // اسم قاعدة للملف بدون الامتداد
    $baseName = $safeName . "_" . uniqid();

    // نسختين: عادي + thumbnail
    $newName = $baseName . ".webp";
    $thumbName = $baseName . "_thumb.webp";

    $dest = $uploadDir . $newName;
    $thumbDest = $uploadDir . $thumbName;

    // حفظ نسخة WebP الأساسية
    $saveOriginal = imagewebp($img, $dest, 80);

    // إنشاء صورة thumbnail بمقاس ثابت 50×50
    $thumbWidth = 50;
    $thumbHeight = 50;

    $thumb = imagecreatetruecolor($thumbWidth, $thumbHeight);
    imagealphablending($thumb, true);
    imagesavealpha($thumb, true);

    // قص أو ضغط الصورة داخل 50×50
    imagecopyresampled(
        $thumb,
        $img,
        0, 0, 0, 0,
        $thumbWidth,
        $thumbHeight,
        imagesx($img),
        imagesy($img)
    );

    $saveThumb = imagewebp($thumb, $thumbDest, 80);

    // تنظيف الذاكرة
    imagedestroy($thumb);
    imagedestroy($img);

    if ($saveOriginal && $saveThumb) {
        $response[] = [
            'success' => true,
            'file' => $newName,        // النسخة الأساسية
            'thumb' => $thumbName,     // نسخة الثمبنيل
            'file_title' => $name
        ];
    } else {
        $response[] = ['success' => false, 'msg' => "فشل حفظ أحد الملفات"];
    }
}

echo json_encode($response, JSON_UNESCAPED_UNICODE);
