<?php
header('Content-Type: application/json; charset=utf-8');

$uploadDir = __DIR__ . "/uploads/images/";
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0755, true);
}

$response = [];

$allowedExtImages = ['jpg', 'jpeg', 'png', 'webp'];
$allowedMimeImages = ['image/jpeg', 'image/png', 'image/gif', 'image/webp'];
$allowedExtDocs = ['pdf'];
$allowedMimeDocs = ['application/pdf'];

// أقصى حجم (3MB)
$maxSize = 10 * 1024 * 1024;

if (!isset($_FILES['files'])) {
    echo json_encode([['success' => false, 'msg' => 'لم يتم استقبال أي ملف']], JSON_UNESCAPED_UNICODE);
    exit;
}

foreach ($_FILES['files']['tmp_name'] as $index => $tmpName) {
    $name = $_FILES['files']['name'][$index];
    $size = $_FILES['files']['size'][$index];

    // التحقق من الحجم
    if ($size > $maxSize) {
        $response[] = ['success'=>false,'msg'=>"الحجم أكبر من 3MB"];
        continue;
    }

    $ext  = strtolower(pathinfo($name, PATHINFO_EXTENSION));
    $filenameOnly = pathinfo($name, PATHINFO_FILENAME);

    // تنظيف الاسم الأصلي (يدعم العربية + يمنع الرموز)
    $safeName = preg_replace(
        '/[^\p{Arabic}A-Za-z0-9_\-]/u',
        '_',
        str_replace('.', '_', $filenameOnly)
    );

    $mime = mime_content_type($tmpName);

    // 🟢 معالجة الصور
    if (in_array($ext, $allowedExtImages) && in_array($mime, $allowedMimeImages)) {

        $img = null;
        switch ($ext) {
            case 'jpg':
            case 'jpeg':
                $img = @imagecreatefromjpeg($tmpName);
                break;
            case 'png':
                $img = @imagecreatefrompng($tmpName);
                imagepalettetotruecolor($img);
                imagealphablending($img, true);
                imagesavealpha($img, true);
                break;
            case 'webp':
                $img = @imagecreatefromwebp($tmpName);
                break;
        }

        if ($img) {
            $newName = $safeName . "_" . uniqid() . ".webp";
            $dest = $uploadDir . $newName;

            if (imagewebp($img, $dest, 80)) {
                $response[] = [
                    'success'=>true,
                    'file'=>$newName,
                    'file_title'=>$name
                ];
            } else {
                $response[] = ['success'=>false,'msg'=>"فشل التحويل إلى WebP"];
            }
            imagedestroy($img);
        } else {
            $response[] = ['success'=>false,'msg'=>"فشل قراءة الصورة"];
        }

    }
    // 🟣 معالجة ملفات PDF
    elseif (in_array($ext, $allowedExtDocs) && in_array($mime, $allowedMimeDocs)) {

        $newName = $safeName . "_" . uniqid() . ".pdf";
        $dest = $uploadDir . $newName;

        if (move_uploaded_file($tmpName, $dest)) {
            $response[] = [
                'success'=>true,
                'file'=>$newName,
                'file_title'=>$name
            ];
        } else {
            $response[] = ['success'=>false,'msg'=>"فشل حفظ ملف PDF"];
        }

    }
    // ❌ نوع ملف غير مسموح
    else {
        $response[] = ['success' => false, 'msg' => "امتداد أو نوع غير مسموح: $ext"];
    }
}

echo json_encode($response, JSON_UNESCAPED_UNICODE);
