/* jQCP - jQuery Color Picker v0.2.1
 *  jQCP is distributed under the terms of the MIT license
 *  For more information visit http://jqframework.com/jqcp
 *  Copyright (C) 2009  jqframework.com
 * Do not remove this copyright message
 */
$.jQCP={imagePath:"img/c_tuner.png",prefix:"",colorObj:null,init:function(id){var prefix=$.jQCP.prefix;
var str='<table class="jqcp_table"><tr>';
str+='<td><div id="'+prefix+'jqcp" class="jqcp"><div id="'+prefix+'marker" class="jqcpmarker"></div></div></td>';
str+='<td><div id="'+prefix+'jqbr" class="jqbr"></td>';
str+='<td><div id="'+prefix+'jqbrp" class="jqbrp"><div id="'+prefix+'c_point" class="jqbrpointer"></div></div></td>';
str+="</tr></table>";
$("#"+id).html(str);
$("#"+prefix+"jqcp").click(function(e){$.jQCP.clickCp(e.pageX,e.pageY)
});
$("#"+prefix+"jqbr").click(function(e){$.jQCP.clickBp(e.pageX,e.pageY)
});
$("#"+prefix+"jqcp_h").keyup(function(e){if($.jQCP.validHSL($("#"+prefix+"jqcp_h").val(),"jqcp_h")){$.jQCP.setHsl()
}});
$("#"+prefix+"jqcp_s").keyup(function(e){if($.jQCP.validHSL($("#"+prefix+"jqcp_s").val(),"jqcp_s")){$.jQCP.setHsl()
}});
$("#"+prefix+"jqcp_l").keyup(function(e){if($.jQCP.validHSL($("#"+prefix+"jqcp_l").val(),"jqcp_l")){$.jQCP.setHsl()
}});
$("#"+prefix+"jqcp_r").keyup(function(e){if($.jQCP.validRGB($("#"+prefix+"jqcp_r").val(),"jqcp_r")){$.jQCP.setRGB()
}});
$("#"+prefix+"jqcp_g").keyup(function(e){if($.jQCP.validRGB($("#"+prefix+"jqcp_g").val(),"jqcp_g")){$.jQCP.setRGB()
}});
$("#"+prefix+"jqcp_b").keyup(function(e){if($.jQCP.validRGB($("#"+prefix+"jqcp_b").val(),"jqcp_b")){$.jQCP.setRGB()
}});
$(".jqcp_value").click(function(e){$.jQCP.colorObj=this.id;
$.jQCP.HextoRGB()
});
$.jQCP.setCpPos();
$.jQCP.setBpPos()
},validHSL:function(value,obj){if(!isNaN(value)){if(value>240){$("#"+$.jQCP.prefix+obj).val(240)
}else{if(value<0){$("#"+$.jQCP.prefix+obj).val(0)
}}return true
}return false
},validRGB:function(value,obj){if(!isNaN(value)){if(value>255){$("#"+$.jQCP.prefix+obj).val(255)
}else{if(value<0){$("#"+$.jQCP.prefix+obj).val(0)
}}return true
}return false
},setCpPos:function(){var pos=$("#"+$.jQCP.prefix+"jqcp").offset();
var x=parseInt($("#"+$.jQCP.prefix+"jqcp_h").val())-4;
var y=240-parseInt($("#"+$.jQCP.prefix+"jqcp_s").val())-4;
$("#"+$.jQCP.prefix+"marker").css({position:"relative",zIndex:5000,left:x+"px",top:y+"px"})
},setBpPos:function(){var pos=$("#"+$.jQCP.prefix+"jqbrp").offset();
var y=240-parseInt($("#"+$.jQCP.prefix+"jqcp_l").val())-5;
$("#"+$.jQCP.prefix+"c_point").css({position:"relative",zIndex:5000,top:y+"px"})
},hsl2rgb:function(){var h=parseInt($("#"+$.jQCP.prefix+"jqcp_h").val())/240;
var s=parseInt($("#"+$.jQCP.prefix+"jqcp_s").val())/240;
var l=parseInt($("#"+$.jQCP.prefix+"jqcp_l").val())/240;
var r,g,b;
if(s==0){r=g=b=l
}else{function hue2rgb(p,q,t){if(t<0){t+=1
}if(t>1){t-=1
}if(t<1/6){return p+(q-p)*6*t
}if(t<1/2){return q
}if(t<2/3){return p+(q-p)*(2/3-t)*6
}return p
}var q=l<0.5?l*(1+s):l+s-l*s;
var p=2*l-q;
r=hue2rgb(p,q,h+1/3);
g=hue2rgb(p,q,h);
b=hue2rgb(p,q,h-1/3)
}$("#"+$.jQCP.prefix+"jqcp_r").val(Math.round(r*255));
$("#"+$.jQCP.prefix+"jqcp_g").val(Math.round(g*255));
$("#"+$.jQCP.prefix+"jqcp_b").val(Math.round(b*255));
$.jQCP.RGBtoHex()
},rgb2hsl:function(){var r=parseInt($("#"+$.jQCP.prefix+"jqcp_r").val())/255;
var g=parseInt($("#"+$.jQCP.prefix+"jqcp_g").val())/255;
var b=parseInt($("#"+$.jQCP.prefix+"jqcp_b").val())/255;
var max=Math.max(r,g,b),min=Math.min(r,g,b);
var h,s,l=(max+min)/2;
if(max==min){h=s=0
}else{var d=max-min;
s=l>0.5?d/(2-max-min):d/(max+min);
switch(max){case r:h=(g-b)/d+(g<b?6:0);
break;
case g:h=(b-r)/d+2;
break;
case b:h=(r-g)/d+4;
break
}h/=6
}$("#"+$.jQCP.prefix+"jqcp_h").val(Math.round(h*240));
$("#"+$.jQCP.prefix+"jqcp_s").val(Math.round(s*240));
$("#"+$.jQCP.prefix+"jqcp_l").val(Math.round(l*240));
$.jQCP.RGBtoHex()
},clickCp:function(x,y){var pos=$("#"+$.jQCP.prefix+"jqcp").offset();
$("#"+$.jQCP.prefix+"jqcp_h").val(Math.round(x-pos.left));
$.jQCP.validHSL($("#"+$.jQCP.prefix+"jqcp_h").val(),"jqcp_h");
$("#"+$.jQCP.prefix+"jqcp_s").val(Math.round(240-y+pos.top));
$.jQCP.validHSL($("#"+$.jQCP.prefix+"jqcp_s").val(),"jqcp_s");
$.jQCP.hsl2rgb();
$.jQCP.changeBpBg();
x=x-4-pos.left;
y=y-4-pos.top;
pos=$("#"+$.jQCP.prefix+"jqcp").offset();
$("#"+$.jQCP.prefix+"marker").css({position:"relative",zIndex:5000,left:x+"px",top:y+"px"})
},clickBp:function(x,y){var pos=$("#"+$.jQCP.prefix+"jqbr").offset();
$("#"+$.jQCP.prefix+"jqcp_l").val(Math.round(240-y+pos.top));
$.jQCP.validHSL($("#"+$.jQCP.prefix+"jqcp_l").val(),"jqcp_l");
$.jQCP.hsl2rgb();
y=y-3-pos.top;
pos=$("#"+$.jQCP.prefix+"jqbrp").offset();
$("#"+$.jQCP.prefix+"c_point").css({position:"relative",zIndex:5000,top:y+"px"})
},changeBpBg:function(){if(navigator.appVersion.indexOf("MSIE")!=-1){$("#"+$.jQCP.prefix+"jqbr").css({backgroundImage:"none",filter:"progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true, sizingMethod=crop, src='"+$.jQCP.imagePath+"')",backgroundColor:$("#"+$.jQCP.prefix+$.jQCP.colorObj).val()})
}else{$("#"+$.jQCP.prefix+"jqbr").css({backgroundColor:$("#"+$.jQCP.prefix+$.jQCP.colorObj).val()})
}},RGBtoHex:function(){$("#"+$.jQCP.prefix+$.jQCP.colorObj).val("#"+$.jQCP.toHex($("#"+$.jQCP.prefix+"jqcp_r").val())+$.jQCP.toHex($("#"+$.jQCP.prefix+"jqcp_g").val())+$.jQCP.toHex($("#"+$.jQCP.prefix+"jqcp_b").val()));
$("#"+$.jQCP.prefix+$.jQCP.colorObj).css({backgroundColor:$("#"+$.jQCP.prefix+$.jQCP.colorObj).val()})
},HextoRGB:function(){var value=$("#"+$.jQCP.prefix+$.jQCP.colorObj).val();
$("#"+$.jQCP.prefix+"jqcp_r").val($.jQCP.HexToR(value));
$("#"+$.jQCP.prefix+"jqcp_g").val($.jQCP.HexToG(value));
$("#"+$.jQCP.prefix+"jqcp_b").val($.jQCP.HexToB(value));
$.jQCP.setRGB()
},setRGB:function(){$.jQCP.rgb2hsl();
$.jQCP.setCpPos();
$.jQCP.setBpPos();
$.jQCP.changeBpBg()
},setHsl:function(){$.jQCP.hsl2rgb();
$.jQCP.setCpPos();
$.jQCP.setBpPos();
$.jQCP.changeBpBg()
},toHex:function(N){if(N==null){return"00"
}N=parseInt(N);
if(N==0||isNaN(N)){return"00"
}N=Math.max(0,N);
N=Math.min(N,255);
N=Math.round(N);
return"0123456789ABCDEF".charAt((N-N%16)/16)+"0123456789ABCDEF".charAt(N%16)
},HexToR:function(h){return parseInt(($.jQCP.cutHex(h)).substring(0,2),16)
},HexToG:function(h){return parseInt(($.jQCP.cutHex(h)).substring(2,4),16)
},HexToB:function(h){return parseInt(($.jQCP.cutHex(h)).substring(4,6),16)
},cutHex:function(h){return(h.charAt(0)=="#")?h.substring(1,7):h
},setColorObj:function(colorObj){$.jQCP.colorObj=colorObj;
$("#"+$.jQCP.prefix+colorObj).unbind("change");
$("#"+$.jQCP.prefix+colorObj).bind("change",function(e){$.jQCP.HextoRGB()
});
$("#"+$.jQCP.prefix+$.jQCP.colorObj).css({backgroundColor:$("#"+$.jQCP.prefix+$.jQCP.colorObj).val()})
},setColor:function(colorObj,color){$.jQCP.colorObj=colorObj;
$("#"+$.jQCP.prefix+colorObj).val(color);
$.jQCP.HextoRGB()
}};
$.fn.extend({jqcp:function(){return this.each(function(){$.jQCP.init(this.id)
})
},jqcp_setObject:function(){return this.each(function(){$.jQCP.setColorObj(this.id)
})
},jqcp_setColor:function(color){return this.each(function(){$.jQCP.setColor(this.id,color)
})
}});