<div id="charts"></div>

<script>
  const rows = document.querySelectorAll("#surveyTable tr");
  const headers = [...rows[0].children].slice(2).map(td => td.textContent);
  const container = document.getElementById("charts");

  for (let i = 1; i < rows.length; i++) {
    const cells = rows[i].children;
    const question = cells[1].textContent;
    const values = [...cells].slice(2).map(td => +td.textContent);
    const max = Math.max(...values) || 1;
    const heightPx = 240;
    const steps = 5;

    const chartBox = document.createElement("div");
    chartBox.className = "chart-container";
    chartBox.innerHTML = `<h4>${question}</h4>`;
    const chartWrapper = document.createElement("div");
    chartWrapper.className = "chart-wrapper";
    const yAxis = document.createElement("div");
    yAxis.className = "y-axis";
    for (let s = steps; s >= 0; s--) {
      const tick = document.createElement("div");
      tick.textContent = Math.round((s/steps)*max);
      yAxis.appendChild(tick);
    }
    const chart = document.createElement("div");
    chart.className = "chart";
    for (let s = 0; s <= steps; s++) {
      const line = document.createElement("div");
      line.className = "y-line";
      line.style.bottom = `${(s/steps)*100}%`;
      chart.appendChild(line);
    }

    values.forEach((v, idx) => {
      const bc = document.createElement("div");
      bc.className = "bar-container";
      const vl = document.createElement("div");
      vl.className = "value-label"; vl.textContent = v;
      const bar = document.createElement("div");
      bar.className = "bar"; bar.style.height = `${(v/max)*heightPx}px`;
      const lbl = document.createElement("div");
      lbl.className = "bar-label"; lbl.textContent = headers[idx];
      bc.append(vl, bar, lbl);
      chart.appendChild(bc);
    });

    chartWrapper.append(yAxis, chart);
    chartBox.appendChild(chartWrapper);
    container.appendChild(chartBox);
  }
</script>



 <style>
  
    h2, h4 { color: #222; }
    .chart-container {
      margin-bottom: 40px;
      background: #fff;
      border: 1px solid #ddd;
      border-radius: 8px;
      padding: 20px;
      box-shadow: 0 2px 6px rgba(0,0,0,0.05);
	  padding-bottom:40px;
	  margin-top:40px;
    }
    .chart-wrapper {
      display: flex;
      align-items: flex-end;
      margin-top: 20px;
    }
    .y-axis {
      display: flex;
      flex-direction: column;
      justify-content: space-between;
      height: 240px;
      margin-left: 15px;
      padding-right: 10px;
      font-size: 14px;
      color: #444;
      border-left: 2px solid #888;
    }
	.y-axis div{
		width:40px;
		text-align:center;
	}
    .chart {
      display: flex;
      align-items: flex-end;
      height: 240px;
      gap: 50px;
      padding: 0 10px;
      flex-grow: 1;
      position: relative;
	  
    }
	
	#charts{
		display:none;
	}
	.open_chart{
		height: 30px;
		color: #fff;
		background: #ff495f;
		display: inline-block;
		padding:5px 10px;
		margin: 20px;
		cursor:pointer;
	}
	
    .y-line {
      position: absolute; left: 0; right: 0;
      height: 1px; background: #ccc;
    }
    .bar-container {
      display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: flex-end;
    width: 45px;
    margin-bottom: -34px;
    }
    .bar {
      width: 100%;
      background-color: #3498db;
      border-radius: 4px 4px 0 0;
      transition: height 0.3s;
    }
    .value-label {
      font-size: 15px;
      margin-bottom: 4px;
      color: #222;
    }
    .bar-label {
      margin-top: 6px;
      font-size: 15px;
      color: #222;
      text-align: center;
    }
  </style>
  
  <script>
  
  $(function(){
	  
	  
	  $(".open_chart").click(function(){
		  // اخفاء واظهار الرسم البيانى
		  $("#charts").slideToggle(400); // المدة: 400ms
		  if($(this).html()=='اظهار الرسم البيانى'){
			  $(this).html('اخفاء الرسم البيانى');
		  }else{
			  $(this).html('اظهار الرسم البيانى');
		  }
	  });
  });
  
  </script>