<?php
require_once __DIR__ . '/phpqrcode/qrlib.php'; // المسار الصحيح للمكتبة



// نص vCard (منسق)
$vcard  = "BEGIN:VCARD\n";
$vcard .= "VERSION:3.0\n";
$vcard .= "FN:$company\n"; // الاسم الكامل (يُفضل إضافته)
$vcard .= "ORG:$company\n";

if (!empty($address1)) $vcard .= "ADR;TYPE=WORK:;;$address1;;;;\n";
if (!empty($mobile1)) $vcard .= "TEL;TYPE=CELL:$mobile1\n";
if (!empty($email1)) $vcard .= "EMAIL;TYPE=INTERNET:$email1\n";
if (!empty($website))  $vcard .= "URL:$website\n";

//if (!empty($face))      $vcard .= "X-SOCIALPROFILE;type=facebook:$face\n";
//if (!empty($instagram)) $vcard .= "X-SOCIALPROFILE;type=instagram:$instagram\n";
//if (!empty($twitter))   $vcard .= "X-SOCIALPROFILE;type=twitter:$twitter\n";
//if (!empty($youtube))   $vcard .= "X-SOCIALPROFILE;type=youtube:$youtube\n";
//if (!empty($snap))      $vcard .= "X-SOCIALPROFILE;type=snapchat:$snap\n";

$vcard .= "END:VCARD\n";
// المجلد المؤقت لحفظ الصورة
$tempDir = __DIR__ . "/../img/";
if (!file_exists($tempDir)) {
    mkdir($tempDir);
}

$fileName = 'qr.png';
$filePath = $tempDir . $fileName;

// إنشاء QR
QRcode::png($vcard, $filePath, QR_ECLEVEL_H, 10);

// عرض الصورة على الصفحة
echo "<h2>تم إنشاء QR بنجاح</h2>";
echo "<img src='../img/$fileName' alt='QR Code'><br>";

?>
