<?php
require_once '../htmlpurifier/HTMLPurifier.auto.php';

function echo_s($html) {
    static $purifier = null;

    if ($purifier === null) {
        $config = HTMLPurifier_Config::createDefault();
        $config->set('HTML.Allowed', 'p,br,strong,b,em,i,ul,ol,li,img[src|alt|title|width|height],a[href|title|target|rel],h1,h2,h3,h4,h5,h6');
        $config->set('HTML.TargetBlank', true);
        $config->set('Attr.AllowedFrameTargets', ['_blank']);
        $config->set('Core.Encoding', 'UTF-8');
        $purifier = new HTMLPurifier($config);
    }

    echo $purifier->purify($html);
}


?>
