<?php

function expandShortUrl($shortUrl) {
    // إعداد curl لتتبع التوجيه
    $ch = curl_init($shortUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_exec($ch);
    $finalUrl = curl_getinfo($ch, CURLINFO_EFFECTIVE_URL);
    curl_close($ch);
    return $finalUrl;
}

function extractCoordinates($url) {
    // إذا كانت وصلة مختصرة (goo.gl/maps)، حاول فكها أولاً
    if (preg_match("/goo\.gl\/maps/", $url)) {
        $headers = @get_headers($url, 1);
        if (isset($headers["Location"])) {
            $url = is_array($headers["Location"]) ? end($headers["Location"]) : $headers["Location"];
        }
    }

    // مجموعة الأنماط الممكنة لاستخراج الإحداثيات
    $patterns = [
        "/@(-?\d+\.\d+),(-?\d+\.\d+)/",            // .../@lat,lng
        "/search\/(-?\d+\.\d+),\+?(-?\d+\.\d+)/",  // .../search/lat,lng
        "/[?&]q=(-?\d+\.\d+),(-?\d+\.\d+)/",       // ...?q=lat,lng
        "/!3d(-?\d+\.\d+)!4d(-?\d+\.\d+)/"         // ...!3dlat!4dlng (غالبًا في place/)
    ];

    foreach ($patterns as $pattern) {
        if (preg_match($pattern, $url, $matches)) {
            return [
                'lat' => floatval($matches[1]),
                'lng' => floatval($matches[2])
            ];
        }
    }

    return false; // لم يتم العثور على إحداثيات
}


function generateEmbedCode($lat, $lng) {
    $embedUrl = "https://www.google.com/maps?q={$lat},{$lng}&output=embed";
    return "<iframe title='$_SESSION[comp_about] - خريطة' width='100%' height='100%' style='border:0;' loading='lazy' allowfullscreen src='{$embedUrl}'></iframe>";
}

// أدخل رابطك هنا 👇
$shortMapUrl = $_SESSION['comp_map'];

// فك الرابط المختصر
$finalUrl = expandShortUrl($shortMapUrl);

// استخراج الإحداثيات
$coords = extractCoordinates($finalUrl);


?>
