<?php
function getYouTubeId($url) {
    // نحاول أولاً تحليل الرابط
    $parts = parse_url(trim($url));

    // الحالة 1: روابط youtu.be القصيرة
    if (isset($parts['host']) && ($parts['host'] == 'youtu.be')) {
        return ltrim($parts['path'], '/');
    }

    // الحالة 2: روابط youtube.com/watch?v=xxxxx
    if (isset($parts['query'])) {
        parse_str($parts['query'], $query);
        if (!empty($query['v'])) {
            return $query['v'];
        }
    }

    // الحالة 3: روابط embed أو /v/
    if (isset($parts['path'])) {
        if (preg_match('/\/embed\/([a-zA-Z0-9_-]+)/', $parts['path'], $matches)) {
            return $matches[1];
        }
        if (preg_match('/\/v\/([a-zA-Z0-9_-]+)/', $parts['path'], $matches)) {
            return $matches[1];
        }
    }

    // الحالة 4: fallback — محاولة الالتقاط بأي صيغة ممكنة
    if (preg_match('/([a-zA-Z0-9_-]{11})/', $url, $matches)) {
        return $matches[1];
    }

    // إذا لم يتم التعرف على الكود
    return null;
}



?>
