<?php
if (session_status() === PHP_SESSION_NONE) session_start();
if (!isset($_SESSION['img_size'])) $_SESSION['img_size'] = '_800';

// جلب البيانات من قاعدة البيانات
$slides = [];
if (isset($conn)) {
    $sql="select `id`,`title`,`desc`,`images`,`achieve`,`desc` from achievements where active =1";		
    $res = mysqli_query($conn, $sql);
    if ($res && mysqli_num_rows($res) > 0) {
        while ($row = mysqli_fetch_assoc($res)) {
            $img_parts = array_filter(array_map('trim', explode(',', $row['images'])));
            if (empty($img_parts)) continue;
            $first_img = basename(reset($img_parts));
            $info = pathinfo($first_img);
            $constructed = 'img_'.$info['filename'].".webp";
            $slides[] = [
                'title' => $row['title'],
                'desc'  => $row['desc'],
                'achieve'  => $row['achieve'],
                'link'  => $row['link'] ?? '#',
                'image' => "$img_path"."achievements/".$constructed
            ];
        }
    }
}
?>

<style>
.container_rain {
    display:flex; 
    align-items:stretch; 
    height:350px;
    padding:0;
    background:url(<?php echo $img_path; ?>acheivements_bg.png) !important;
    background-size:cover;
    position:relative;
	
}
.container_rain:after{
    content: "";
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: #2b254bdd;
    -webkit-backdrop-filter: blur(2px);
    backdrop-filter: blur(2px);
    z-index: 1;
}
.rain_slider {
  flex: 2;
  display:flex;
  justify-content: center;
  overflow: hidden;
  z-index:2;
  
}
.rain_col {
  flex:1;
  display:flex;
  flex-direction:column;
  align-items:center;
  gap:30px;
  max-width:210px;
  animation: rainFall 10s ease-in-out infinite alternate;
}

.rain_col:nth-child(2) {
	padding-top:100px;
}

.rain_slide {
  background: #fff;
  border-radius: 15px;
  box-sizing: border-box;
  width: 100%;
  max-width: 180px;
  min-width: 120px;
}
.rain_slide img {
	width: 80%;
    height: auto;
    border-radius: 10px 10px 0 0;
    display: block;
    margin: 10%;
    border-radius: 15px;
}
.caption {
  background:#fff;
  color:#000;
  padding:10px;
  border-radius: 0 0 10px 10px;
}
.caption h3 {
  margin:0;
  font-size:16px;
  font-weight:bold;
  line-height:1.3;
  text-align:center;
}
.caption p {
	font-size: 30px;
    margin: 5px 0 0;
    color: var(--magenta, #333);
    font-weight: bold;
	text-align:center;
  
}

/* حركة المطر */
@keyframes rainFall {
  0%   { transform: translateY(10%); opacity: 1; }
  50%  { transform: translateY(-125%); opacity: 1; }
  100% { transform: translateY(10%); opacity: 1; }
}

.rain_info {
  flex: 1;
  padding:30px;
  display:flex;
  flex-direction:column;
  justify-content:center;
  z-index:2;
}
.rain_slider:hover .rain_col {
  animation-play-state: paused;
}

.rain_info h2 {font-size:32px; margin-bottom:15px;margin-top:30px;color:#fff;}
.rain_info p {font-size:18px; line-height:1.5;color:#fff;}
.btn-main{
    display: inline-block;
    padding: 12px 18px;
    background: #ffffff22;
    color: #fff;
    text-decoration: none;
    border-radius: 8px;
    transition: background 0.3s;
    border: solid 1px #ffffff44;
    width: fit-content;
    margin-top: 20px;	
}
.btn-main:hover {background:#ffffff44;}
.cont_fixed_width{
	max-width: 1200px;margin: 0 auto;display: flex;
}

/* Responsive */
@media(max-width:768px){
  .container_rain{flex-direction:column;height:600px;}
  .rain_info{order:-1;}
  .rain_slide{width:60%; max-width:150px;}
  
  .cont_fixed_width{
	flex-direction: column;
	height: 600px;
  }
  
  .rain_col{
	  width:80px;
  }
}


</style>
</head>
<body>
<div class="container_rain container-fluid" >
<div class='cont_fixed_width'>
  <div class="rain_slider order-2">
   <?php 
$numCols = 3;
$cols = array_fill(0, $numCols, []); // مصفوفة فيها 3 أعمدة فاضية

foreach ($slides as $i => $s) {
    $colIndex = $i % $numCols; // توزيع دائري
    $cols[$colIndex][] = $s;
}

foreach($cols as $colSlides): ?>
  <div class="rain_col">
    <?php foreach($colSlides as $s): ?>
      <div class="rain_slide">
        <a >
          <img src="<?= $s['image'] ?>" alt="<?= htmlspecialchars($s['title']) ?>">
        </a>
        <div class="caption">
          <h3><?= htmlspecialchars($s['title']) ?></h3>
          <p><?= htmlspecialchars($s['achieve']) ?></p>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
<?php endforeach; ?>

  </div>
  <div class="rain_info order-1">
    <h2><i class="las la-certificate"></i> أرقام وإحصائيات</h2>
    <p>آخر الأرقام والإحصاءات حول الخدمات المقدمة للموهوبين والمبدعين</p>
    <a id="link" href="1111" class="btn-main">اعرف المزيد</a>
  </div>
</div>

</div>
