$(document).ready(function(){

    (function($) {
        "use strict";

    
    jQuery.validator.addMethod('answercheck', function (value, element) {
        return this.optional(element) || /^\bcat\b$/.test(value)
    }, "type the correct answer -_-");

    // validate contactForm form
    $(function() {
        $('#contactForm').validate({
            rules: {
                name: {
                    required: true,
                    minlength: 8
                },
                subject: {
                    required: true,
                    minlength: 10
                },
                mobile: {
                    required: true,
                    minlength: 11
                },
                email: {
                    required: true,
                    email: true
                },
                message: {
                    required: true,
                    minlength: 20
                }
            },
            messages: {
                name: {
                    required: "هذا الحقل مطلوب",
                    minlength: "ادحل اسم صحيح"
                },
                subject: {
                    required: "هذا الحقل مطلوب",
                    minlength: "ادخل عنوان صحيح"
                },
                mobile: {
                    required: "هذا الحقل مطلوب",
                    minlength: "ادخل رقم  جوال صحيح"
                },
                email: {
                    required: "هذا الحقل مطلوب"
                },
                message: {
                    required: "هذا الحقل مطلوب",
                    minlength: "ادخل مقترح طويل"
                }
            },
            submitHandler: function(form) {
                $(form).ajaxSubmit({
                    type:"POST",
                    data: $(form).serialize(),
                    url:"suggessions.php",
                    success: function() {
                        $('#contactForm :input').attr('disabled', 'disabled');
                        $('#contactForm').fadeTo( "slow", 1, function() {
                            $(this).find(':input').attr('disabled', 'disabled');
                            $(this).find('label').css('cursor','default');
                            $('#success').fadeIn()
                            $('.modal').modal('hide');
		                	$('#success').modal('show');
                        })
						
						$('#form_success').fadeIn(1000);
                    },
                    error: function() {
                        $('#contactForm').fadeTo( "slow", 1, function() {
                            $('#error').fadeIn()
                            $('.modal').modal('hide');
		                	$('#error').modal('show');
                        })
                    }
                })
            }
        })
    })
        
 })(jQuery)
})