<style>
.h_slider {
      position: relative;
      width: 100%;
      height: 75vh; /* ارتفاع نسبي */
      overflow: hidden;
    }

    .h_slider img {
      position: absolute;
      top: 30vh;
      transform: translateY(-50%);
      border-radius: 50px;
      cursor: pointer;
      transition: all 0.5s ease;
      max-width: 100%;
      height: auto;
      object-fit: contain;
    }



	img.pos0,img.pos1,img.pos2,img.pos3  {
	 
	  object-fit: cover !important ; 
	}

    .pos0 { left: 30%; width: 26vw;height: 26vw !important;aspect-ratio:1 / 1; z-index: 4; }
    .pos1 { left: 10%; width: 22vw;height: 22vw !important;aspect-ratio:1 / 1; z-index: 3; }
    .pos2 { left: 2%;  width: 18vw;height: 18vw !important;aspect-ratio:1 / 1; z-index: 2; }
    .pos3 { left: -5%;  width: 12vw;height: 12vw !important;aspect-ratio:1 / 1; z-index: 1;  }

    /* التحكم السفلي */
    .slide_bottom_controls {
      display:block;
      align-items: center;
      justify-content: center;
      gap: 10px;
      margin-top: 15px;
      float:right;
      width:100%;
      margin-top:10px;
    }

    .slide_btn_nav {
      background: rgba(0,0,0,0.6);
      color: #fff;
      border: none;
      font-size: 18px;
      padding: 6px 12px;
      border-radius: 6px;
      cursor: pointer;
      transition: background 0.3s;
      display:none;
    }
    .slide_btn_nav:hover { background: rgba(0,0,0,0.9); }

    .dots {
        display: flex;
		justify-content: right;
		align-items: center;
		gap: inherit;
    }
    .dot {
      width: 10px;
      height: 10px;
      border-radius: 50%;
      background: #bbb;
      cursor: pointer;
      transition: background 0.3s;
    }
    .dot.active {
      background: var(--red_bg);
      width:30px;
      border-radius:20px;
    }

    /* الوصف */
    .h_slider_description {
      padding: 20px;
      color:#fff;
      border-radius: 12px;
    }
    .h_slider_description h2 {
      margin: 0 0 15px;
      font-size: 26px;
      text-align:right;
    }
    .h_slider_description p {
      font-size: 16px;
      line-height: 1.6;
      margin-bottom: 20px;
      text-align:right;
      color:#fff;
    }
    .h_slider_description a.btn-main {
        display: inline-block;
        padding: 10px 18px;
        background: #ffffff22;
        color: #fff;
        text-decoration: none;
        border-radius: 8px;
        transition: background 0.3s;
        float: right;
        border: solid 1px #ffffff44;
    }
    .h_slider_description a.btn-main:hover {
      background: #0056b3;
    }

    /* الريسبونسيف (الموبايل) */
    @media (max-width: 768px) {
	
	.h_slider img {
		top: 50%;
	}
	.dots{
		justify-content: center;
	}

	.h_slide_cont{
		padding: 10px !important;
	}
	
      .h_slider { 
		margin-right: -10px;
        height: 37vh;
        margin-top: 30px; 
	  }
      .pos0 { left: 12%; width: 80vw; z-index: 4; height:100% !important; }
      .pos1 { left: 9%; width: 70vw; z-index: 3;  height:100% !important; }
      .pos2 { left: 6%;  width: 60vw; z-index: 2; height:100% !important; }
      .pos3 { left: 3%;  width: 50vw; z-index: 1; height:100% !important; }

      .h_slider_description { margin-top: 15px; text-align: center; padding: 15px; }
     

      .h_slider_description h2 { font-size: 20px;text-align:center }
      .h_slider_description p { font-size: 14px;text-align:center }
      .h_slider_description a.btn-main { font-size: 14px; padding: 8px 14px;float:none; }
    }

    .h_slider_text_cont{ padding:40px;z-index:1; }
	.hero__video{
		position: absolute;
		top: 0;
		left: 0;
		height: 100%;
		
	}
	
	.h_slider_images_cont{
		padding:0px;
	}
	.video_overlay{
		position: absolute;
		top: 0;
		left: 0;
		height: 100%;
		width:100%;
		background:#29184399;
		-webkit-backdrop-filter:blur(20px);
		backdrop-filter:blur(20px);
		z-index:1;
	}
	
	.h_slide_cont{

		width: 98vw;
		padding: 0;
		margin: 140px auto 50px auto !important;
		overflow: hidden;
		height: calc( 100vh - 200px);
		padding: 50px 0px;
		
	}
  </style>
</head>
<body>

<div class="container-fluid h_slide_cont" style="">
	<div class='video_overlay'></div>
	<video class="hero__video" playsinline="" autoplay="" muted="" loop="" data-uw-rm-av="vi">
        <source src="https://www.mawhiba.sa//media/uwhbxflj/0add-438d-a436-5eaa80979fab.mp4">
    </video>
	
  <div class="row align-items-center flex-row-reverse">
    <!-- الوصف -->
    <div class="col-md-4 col-12 mb-4 mb-lg-0 order-2 h_slider_text_cont">
      <div class="h_slider_description text-center text-lg-start">
        <h2 id="title">العنوان 1</h2>
        <p id="text">هذا هو الوصف الخاص بالصورة الأولى.</p>
        <a id="link" href="#" class="btn-main">اعرف المزيد</a>
        <br><br>
        <!-- التحكم السفلي -->
        <div class="slide_bottom_controls mt-3">
          <button class="slide_btn_nav prev">&#10094;</button>
          <div class="dots"></div>
          <button class="slide_btn_nav next">&#10095;</button>
        </div>
      </div>
    </div>

    <!-- السلايدر -->
    <div class="col-md-8 col-12 order-1 h_slider_images_cont">
      <div class="h_slider">
        
	<?php
	/*بداية الاستعلام*/  
	$main_slide_query="select `id`,`title`,`desc`,`link`,`video`,`images` from main_slide where active=1 order by `priority` desc , `sort` desc , id desc";
	$main_slide_result=mysqli_query($conn,$main_slide_query);	
	$current_slide=0;
	// بداية التكرار
	while($main_slide_fetch = mysqli_fetch_array($main_slide_result)) {
   		 $main_slide_fetch = clean_array($main_slide_fetch);
		$current_slide++;		
		
		
		if($main_slide_fetch['video']==''){
			//فى حالة السلايد صورة
			/*استخراج جميع الصور*/  
			$current_image=explode(",",$main_slide_fetch['images']);
			$current_image_small=explode(".",$current_image[1]);
			$current_image_small=$current_image_small[0]."_tiny.webp";

			/*استخراج الصورة الاساسية*/  
			$current_image=explode(".",$current_image[1]);
				
		}else{
			//فى حالة السلايد فيديو	
			// استخراج الفيديو من اليوتيوب
			$current_video=explode('&',$main_slide_fetch['video']);
			$current_video=explode('v=',$current_video[0]);
		}
		
		$h_slider_descriptions[]=[ "title" => "$main_slide_fetch[title]", "text" => "$main_slide_fetch[desc]", "link" => "$main_slide_fetch[link]" ];

	
	?>
		
		<img src="<?php echo $img_path; ?>main_slide/<?php echo $current_image[0].$_SESSION['img_size'].'.webp'; ?>" alt="<?php echo $main_slide_fetch['title']; ?>">
     
	 <?php } ?>
      </div>
    </div>
  </div>
</div>

<!-- jQuery -->
<script>
  $(function() {
    const $slides = $(".h_slider img");
    const $dotsContainer = $(".dots");
    const $title = $("#title");
    const $text = $("#text");
    const $link = $("#link");

    let positions = ["pos3", "pos2", "pos1", "pos0"];
    let current = 0;
    let autoSlide;

    const h_slider_descriptions = <?php echo json_encode($h_slider_descriptions, JSON_UNESCAPED_UNICODE); ?>

    // إنشاء النقاط مرة واحدة فقط
    $slides.each((i) => {
      const $dot = $("<div>").addClass("dot");
      if (i === 0) $dot.addClass("active");
      $dot.on("click", () => goToSlide(i));
      $dotsContainer.append($dot);
    });
    const $dots = $(".dot");

    function updateSlides() {
      $slides.each((i, slide) => $(slide).attr("class", positions[i]));
      updateDots();
      updateh_slider_description();
    }

    function updateDots() {
      $dots.removeClass("active").eq(current).addClass("active");
    }

    function updateh_slider_description() {
      $title.text(h_slider_descriptions[current].title);
      $text.text(h_slider_descriptions[current].text);
      $link.attr("href", h_slider_descriptions[current].link);
    }

    function nextSlide() {
      positions.push(positions.shift());
      current = (current + 1) % $slides.length;
      updateSlides();
    }

    function prevSlide() {
      positions.unshift(positions.pop());
      current = (current - 1 + $slides.length) % $slides.length;
      updateSlides();
    }

    function goToSlide(index) {
      while (current !== index) {
        nextSlide();
      }
      resetAutoSlide();
    }

    function startAutoSlide() {
      autoSlide = setInterval(nextSlide, 5000);
    }

    function resetAutoSlide() {
      clearInterval(autoSlide);
	  
      startAutoSlide();
    }

    $(".next").on("click", () => { nextSlide(); resetAutoSlide(); });
    $(".prev").on("click", () => { prevSlide(); resetAutoSlide(); });

    $slides.on("click", function() {
      goToSlide($slides.index(this));
    });

    // ==== دعم Swipe للموبايل ====
    let touchStartX = 0;
    let touchEndX = 0;

    $(".h_slider").on("touchstart", function(e) {
      touchStartX = e.originalEvent.touches[0].clientX;
    });

    $(".h_slider").on("touchend", function(e) {
      touchEndX = e.originalEvent.changedTouches[0].clientX;
      handleSwipe();
    });

    function handleSwipe() {
      const swipeThreshold = 50; // px
      const diffX = touchStartX - touchEndX;
      if (Math.abs(diffX) > swipeThreshold) {
        if (diffX > 0) {
          nextSlide();   // يسار → التالي
        } else {
          prevSlide();   // يمين → السابق
        }
        resetAutoSlide();
      }
    }

    // بدء
    updateSlides();
    startAutoSlide();
  });
</script>