

<section style='margin:20px;'>
  <main class="subscribe-card" aria-label="نموذج الاشتراك">
  
    <form class="subscribe-form" id="subscribeForm" >
		<div id="message-box" style=" margin-top:15px; text-align:center; font-size:16px; font-weight:600;"></div>
		<span>
			<img style='height:50px;' src="<?php echo $img_path; ?>subscribe_mail.png" class="con">

		</span>	
		<span>
			<span style='font-size: 26px;text-align:center;width: 100%;margin-bottom: 0px;display: block;margin-top: 5px;'>إشترك بالنشرة البريدية</span>
			<span style='text-align:center;font-size: 13px;display: block;margin-top: 12px;' >لتصلك التحديثات الخاصة بجمعيتنا أولاً بأول</span>
		</span>
      <!-- حقل الاسم -->
      <label class="field" for="name-input">
        <!-- أيقونة المستخدم -->
        <span class='las la-user'></span>
        <input id="name-input" name="name" type="text" placeholder="الاسم" aria-label="الاسم" autocomplete="name" required>
      </label>

      <!-- حقل الايميل -->
      <label class="field" for="email-input">
        <!-- أيقونة الايميل -->
        <span class='las la-envelope'></span>
        <input id="email-input" name="email" type="email" placeholder="البريد الإلكتروني" aria-label="البريد الإلكتروني" autocomplete="email" required>
      </label>

      <!-- زر الاشتراك -->
      <button class="btn sub_button" type="submit" aria-label="اشترك">
        <!-- أيقونة السهم -->
		 اشتراك
		
       
      </button>

    </form>

  </main>




  
</section>

<script>
$(document).ready(function() {

  $("#subscribeForm").on("submit", function(e) {
    e.preventDefault();

    // تحقق من الحقول
    if (!this.reportValidity()) return;

    const name = $("#name-input").val().trim();
    const email = $("#email-input").val().trim();

    // إخفاء أي رسالة سابقة
    $("#message-box").hide();

    // إرسال البيانات عبر AJAX
    $.ajax({
      url: "send_subscribe.php", // ← غيّرها إلى سكربت الإرسال عندك
      method: "POST",
      data: { name: name, email: email },
      dataType: "json",
      beforeSend: function() {
        $(".sub_button").prop("disabled", true).text("جارٍ الإرسال...");
      },
      success: function(response) {
        $(".sub_button").prop("disabled", false).text("اشتراك");

        if (response.success) {
          // ✅ نجاح
		  $(".subscribe-form")
          $(".subscribe-form").html("✅ تم الاشتراك بنجاح! شكرًا لك " + name + " ❤️", "success");
        } else {
          // ⚠️ فشل من السيرفر
          showMessage("⚠️ حدث خطأ أثناء الإرسال: " + (response.message || "يرجى المحاولة مرة أخرى."), "error");
        }
      },
      error: function() {
        $(".sub_button").prop("disabled", false).text("اشتراك");
        showMessage("❌ لم يتم الإرسال. تحقق من اتصالك بالإنترنت.", "error");
      }
    });
  });

  // دالة لإظهار الرسالة بشكل جميل
  function showMessage(text, type) {
    const box = $("#message-box");
    box
      .text(text)
      .css({
        display: "block",
        padding: "12px",
        borderRadius: "10px",
        transition: "0.3s",
        background: type === "success" ? "#d1fae5" : "#fee2e2", // لون الخلفية
        color: type === "success" ? "#065f46" : "#991b1b",       // لون النص
        border: type === "success" ? "1px solid #10b981" : "1px solid #ef4444"
      })
      .fadeIn(400)
      .delay(4000)   // تبقى 4 ثوانٍ
      .fadeOut(600); // ثم تختفي تدريجيًا
  }

});
</script>

	<style>
    /* الحاوية */
	
    .subscribe-card{
		background: var(--card);
		border-radius: var(--radius);
		box-shadow: 0 6px 20px rgba(16,24,40,0.06);
		padding: 10px;
		width: 100%;
		max-width: 1200px;
		margin: 100px auto;
		padding: 35px;
		background: #e5d3b9;
		border-radius: 20px;
		
    }

    .subscribe-form{
      display:flex;
      gap:10px;
      align-items:center;
      flex-wrap:wrap; 
	  justify-content: center;
	  
    }

    /* حقل مشترك لعنصر الأيقونة + الإدخال */
    .field{
		display: flex;
		align-items: center;
		gap: 8px;
		background: #f3f4f6;
		padding: 8px 10px;
		border-radius: 10px;
		flex: 1 1 110px;
		margin-bottom: 0px;
		height: 45px;
    }

    .field svg{width:20px;height:20px;flex:0 0 20px;opacity:0.9}

    .field input{
      border:0;background:transparent;outline:none;font-size:14px;width:100%;direction:rtl; /* direction لادخال الايميل ليتصرف طبيعي */
    }

    /* زر الإرسال */
    .sub_button{
      display:inline-flex;align-items:center;gap:8px;padding:10px 14px;border-radius:10px;border:0;background:linear-gradient(180deg,var(--primary),#1e40af);color:#fff;font-weight:600;cursor:pointer;flex:0 0 auto
	}
	.sub_button:hover{
		color:#ddd;
	}

    /* نص صغير توضيحي */
    .hint{font-size:12px;color:var(--muted);margin-top:8px;text-align:center}

    /* استايلات تفاعلية */
    .field:focus-within{box-shadow:0 0 0 3px rgba(37,99,235,0.12)}
    .btn:active{transform:translateY(1px)}

    /* responsive: على الشاشات الصغيرة اجعل الزر ممتد بعرض المحتوى بالكامل أسفل الحقول */
    @media (max-width:480px){
      .subscribe-form{gap:8px}
      .btn{width:100%;justify-content:center}
      .field{flex-basis:100%;min-width:unset}
    }

  </style>