<?php
if (session_status() === PHP_SESSION_NONE) session_start();
if (!isset($_SESSION['img_size'])) $_SESSION['img_size'] = '_800';

// جلب البيانات من قاعدة البيانات
$slides = [];
if (isset($conn)) {
 
			
			$sql="select `id`,`title`,`desc`,`images`,`achieve`,`desc` from achievements where active =1";		
	
		
		
    $res = mysqli_query($conn, $sql);
    if ($res && mysqli_num_rows($res) > 0) {
        while ($row = mysqli_fetch_assoc($res)) {
            $img_parts = array_filter(array_map('trim', explode(',', $row['images'])));
            if (empty($img_parts)) continue;
            $first_img = basename(reset($img_parts));
            $info = pathinfo($first_img);
            $constructed = $info['filename'].$_SESSION['img_size'].".webp";
            $slides[] = [
                'title' => $row['title'],
                'desc'  => $row['desc'],
				'achieve'  => $row['achieve'],
                'link'  => $row['link'],
                'image' => "<?php echo $img_path; ?>achievements/".$constructed
            ];
        }
    }
}
// fallback لو مافي بيانات
if (empty($slides)) {
    $slides = [
        ['title'=>'عنوان 1','desc'=>'وصف للصورة الأولى','link'=>'#','image'=>'https://via.placeholder.com/200x150/007bff/fff?text=1'],
        ['title'=>'عنوان 2','desc'=>'وصف للصورة الثانية','link'=>'#','image'=>'https://via.placeholder.com/200x150/28a745/fff?text=2'],
        ['title'=>'عنوان 3','desc'=>'وصف للصورة الثالثة','link'=>'#','image'=>'https://via.placeholder.com/200x150/f39c12/fff?text=3'],
    ];
}
?>
<!DOCTYPE html>
<html lang="ar">
<head>
<meta charset="utf-8" />
<title>سلايدر مطر</title>
<style>

.container_rain {display:flex; align-items:stretch; height:400px;padding:0px;}

/* القسم الأيسر */
.rain_slider {
  flex: 2;
  position: relative;
  overflow: hidden;
  background: linear-gradient(180deg,#051225 0%,#07111a 100%);
}

.rain_slide {
  position: absolute;
  top: -250px;

  text-align:center;
  animation: rainFall linear infinite;
  background: #fff;
  border-radius: 20px;
  padding: 10px;
  box-sizing: border-box;
  width: 15vw; 
  max-width:200px;
}
.rain_slide img {
  width: 100%;
  border-radius: 10px 10px 0 0;

  display:block;
}
.caption {
  background:#fff;
  color:#000;
  padding:10px;
  border-radius: 0 0 10px 10px;

}
.caption h3 {
  margin:0;
  font-size:24px;
  font-weight:bold;
}
.caption p {
  font-size:22px;
  margin:5px 0 0;
  color:#333;
}

.caption h2 {
	 font-size:24px; 
	 margin-bottom:15px;
	 min-height: 50px;
}
.caption p {
	font-size: 40px;
    margin: 5px 0 0;
    color: var(--magenta);
    font-weight: bold;
    height: 50px;
    line-height: 50px !important;
	
}



/* حركة المطر */
@keyframes rainFall {
  0%   { top: -250px; opacity:0; }
  10%  { opacity:1; }
  70%  { top: 80%; opacity:1; }
  80%  { top: 100%; opacity:1; }
  81%  { opacity:0; }            
  100% { top: -250px; opacity:0; } 
}

/* القسم الأيمن */
.rain_info {
  flex: 1;
  background:#111;
  padding:30px;
  display:flex;
  flex-direction:column;
  justify-content:center;
}
.rain_info h2 {font-size:28px; margin-bottom:15px;}
.rain_info p {font-size:16px; line-height:1.5;}

/* Responsive */
@media(max-width:768px){
  .container_rain{flex-direction:column;}
  .rain_info{order:-1;}
}
</style>
</head>
<body>
<div class="container_rain container-fluid">
  <div class="rain_slider">
    <?php foreach($slides as $i=>$s): 
	  $columns = [5, 28, 51, 74]; 
	  $left = $columns[$i % count($columns)];
	  $delay = $i * 5; 
    ?>
      <div class="rain_slide" style="left:<?= $left ?>%; animation-duration:8s; animation-delay:<?= $delay ?>s;">
        <a href="<?= $s['link'] ?>">
          <img src="<?= $s['image'] ?>" alt="<?= htmlspecialchars($s['title']) ?>">
        </a>
        <div class="caption">
          <h3><?= htmlspecialchars($s['title']) ?></h3>
          <p><?= htmlspecialchars($s['achieve']) ?></p>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
  <div class="rain_info">
    <h2>أرقام وإحصائيات</h2>
    <p>
      هذا الجزء الأيمن ثابت لعرض العنوان أو الوصف العام.
      الصور مع العناوين تتحرك مثل المطر في الجزء الأيسر فقط.
    </p>
  </div>
</div>
</body>
</html>
